/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	BeeHive
**
** DESCRIPTION:	Bee hive puzzle
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef BEEHIVE_H
#define BEEHIVE_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"
#include "PuzzleInterface.h"
#include "Puzzle.h"
#include "../Collectables/CollectableInterface.h"
#include "../Game/GameTimer.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const ldwPoint BeeHive_c_sPos(1140, 387);
const int BeeHive_c_iInitialHoney = 500;
const int BeeHive_c_iMinHoney = 10;
const int BeeHive_c_iMaxHoney = 3000;
const int BeeHive_c_iHoneyPerHour = 2;
const int BeeHive_c_iHoneyBowlAmount = 4;
const int BeeHive_c_iSmokeTime = 300;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CBeeHive : public IPuzzle, public ICollectable
{
	friend class CPuzzle;

private:

	//class structures
	struct SSaveState
	{
		unsigned int	m_uiBurnOutTime;
		unsigned int	m_uiLastHoneyTime;
		int				m_iHoney;
		bool			m_bBeesCleared;
	};

	//class data
	CGameTimer		m_BurnOutTimer;

	unsigned int	m_uiLastHoneyTime;
	int				m_iHoney;
	bool			m_bBeesCleared;

	int				m_iSmoke;
	int				m_iSmokeSound;
	int				m_iSwarm[3];
	
	ldwImageGrid *	m_pStick;

	//class methods
	//setup
	public:		CBeeHive(void);
	public:		void Reset();
	public:		void LoadAssets();
	public:		void ReleaseAssets();
	public:		const int LoadState(const unsigned char *pData);
	public:		const int SaveState(const unsigned char *pData, const int iMaxDataSize) const;

	// process
	public:		void Refresh();
	public:		void Draw() const;
	public:		void Draw(const int iRef) const;
	public:		void Update();

	public:		const bool Carry(CVillager &Villager, const ECarrying eCarrying);
	public:		void Drop(CVillager &Villager, const ECarrying eCarrying);
	public:		int Honey() { return m_iHoney; }
	public:		bool EnoughHoneyToHarvest() { return m_iHoney > BeeHive_c_iMinHoney; }
	public:		void LightStick();
	public:		void ExtinguishStick();
	public:		void Complete();
	public:		void SwarmVillager(CVillager &Villager);

	// access
	public:		const ECarrying GetNearbyCollectable(CVillager &Villager, const ldwPoint sPos);
	public:		const bool IsSmokingStickPresent() const;
	public:		const bool IsSwarming() const;
	public:		const bool HasHoneyToHarvest() const;
	public:		void SetHoneyAvailable(const int iHoney);
	public:		const int GetHoneyAvailable();

};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CBeeHive		BeeHive;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/